﻿$IntuneDeployScriptDir = "C:\ProgramData\IntuneDeployedScripts"
if(!(Test-Path $IntuneDeployScriptDir)){
    New-Item -ItemType Directory -Path $IntuneDeployScriptDir -Force
}

Function Log-Message{
    param (
        [string]$message,
        [string]$Logfile = "C:\ProgramData\IntuneDeployedScripts\DTBC-0080_STIG.log"   
    )
    $Timestamp = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
    "$Timestamp - $message" | Out-File -FilePath $Logfile -Append
}

$GoogleChromeRegPath = "HKLM:\Software\Policies\Google\Chrome"
$TabCompareSettingsKey = "TabCompareSettings"
$TabCompareSettingsValue = 2
if(!(Test-Path $GoogleChromeRegPath)){
    Log-Message -message "$GoogleChromeRegPath registry path not found"
    New-Item -Path $GoogleChromeRegPath -Force | Out-Null
    Log-Message -message "$GoogleChromeRegPath registry path created"
    New-ItemProperty -Path $GoogleChromeRegPath -Name $TabCompareSettingsKey -Value $TabCompareSettingsValue -PropertyType DWORD -Force | Out-Null
    Log-Message -message "$TabCompareSettingsKey registry key created value $TabCompareSettingsValue "
} else {
    Log-Message -message "Checking value of $TabCompareSettingsKey registry key expecting $TabCompareSettingsValue"
    Try {
        $TabCompareSettingsCheck = Get-ItemPropertyValue -Path $GoogleChromeRegPath -Name $TabCompareSettingsKey
        if($TabCompareSettingsCheck -ne $TabCompareSettingsValue){
            Log-Message -message "$TabCompareSettingsKey configured incorrect value: $TabCompareSettingsCheck"
            New-ItemProperty -Path $GoogleChromeRegPath -Name $TabCompareSettingsKey -Value $TabCompareSettingsValue -PropertyType DWORD -Force | Out-Null
            Log-Message -message "Set $TabCompareSettingsKey value: $TabCompareSettingsValue"

        } else {
            Log-Message -message "$TabCompareSettingsKey properly configued. No changes needed"
        }
    } Catch {
        Log-Message -message "The property does not exist or an error occurred: $_"
        New-ItemProperty -Path $GoogleChromeRegPath -Name $TabCompareSettingsKey -Value $TabCompareSettingsValue -PropertyType DWORD -Force | Out-Null
        Log-Message -message "Set $TabCompareSettingsKey value: $TabCompareSettingsValue"
    }
}